/******************************************************************************
  @file    asr.c
  @brief   asr log tool.

  DESCRIPTION
  QLog Tool for USB and PCIE of Quectel wireless cellular modules.

  INITIALIZATION AND SEQUENCING REQUIREMENTS
  None.

  ---------------------------------------------------------------------------
  Copyright (c) 2016 - 2020 Quectel Wireless Solution, Co., Ltd.  All Rights Reserved.
  Quectel Wireless Solution Proprietary and Confidential.
  ---------------------------------------------------------------------------
******************************************************************************/
#include "qlog.h"

struct CSDLFileHeader
{
	uint32_t    dwHeaderVersion;//0x0
	uint32_t    dwDataFormat;//0x1
	uint32_t    dwAPVersion;
	uint32_t    dwCPVersion;
	uint32_t    dwSequenceNum;//ļţ0ʼ
	uint32_t    dwTime;//Total seconds from 1970.1.1 0:0:0
	uint32_t    dwCheckSum;//0x0
};

ssize_t asr_send_cmd(int fd, const unsigned char *buf, size_t size) {
    size_t wc = 0;

    while (wc < size) {
        uint32_t *cmd_data = (uint32_t *)(buf+wc);
        unsigned cmd_len =  qlog_le32(cmd_data[0]);
        unsigned rx_count = g_rx_log_count;
        int rx_wait = 100;
        //unsigned i;

        if (cmd_len > (size - wc))
            break;

        //qlog_dbg("Send CMD to UE: ");
        //for(i=0; i<cmd_len; i++)
        //    printf("0x%02X ", buf[wc+i]);
        //printf("\n");

        qlog_poll_write(fd, buf+wc, cmd_len, 1000);

        while (rx_wait-- > 0) {
            if (g_rx_log_count != rx_count)
                break;
            usleep(1*1000);
            //qlog_dbg("c=%u wc=%zd\n", g_rx_log_count, wc);
        }

        wc += cmd_len;
    }

    return wc ;
}

static int asr_init_filter(int fd, const char *cfg) {
    unsigned char ACATReady[16] = {0x10, 0x00, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};	// ACAT Ready command
    unsigned char GetAPDBVer[16] = {0x10, 0x00, 0x00, 0x00, 0x80, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};	// Get AP DB Ver command
    unsigned char GetCPDBVer[16] = {0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};	// Get CP DB Ver command

    //Send the ACAT Ready to UE
    usleep(200);
    asr_send_cmd(fd, ACATReady, 16);
    usleep(200);
    asr_send_cmd(fd, GetAPDBVer, 16);
    usleep(300);
    asr_send_cmd(fd, GetCPDBVer, 16);

    return 0;
}

static int asr_logfile_init(int logfd, unsigned logfile_seq) {
    struct CSDLFileHeader SDLHeader;
    size_t size = sizeof(struct CSDLFileHeader);
    ssize_t nbytes;
    time_t ltime;

    // init the SDL file header
    SDLHeader.dwHeaderVersion = 0x0;
    SDLHeader.dwDataFormat = qlog_le32(0x1);//0x1
    SDLHeader.dwAPVersion = 0x0;
    SDLHeader.dwCPVersion = 0x0;
    SDLHeader.dwTime = 0x0;//Total seconds from 1970.1.1 0:0:0
    SDLHeader.dwCheckSum = 0x0;//0x0

    time(&ltime);

    SDLHeader.dwTime = qlog_le32(ltime); //Total seconds from 1970.1.1 0:0:0
    SDLHeader.dwSequenceNum = qlog_le32(logfile_seq); //ļţ0ʼ

    // Write the file header.
    nbytes = write(logfd, &SDLHeader, size);
    if (nbytes != (ssize_t)size) {
        qlog_dbg("write %zd/%zd, errno: %d (%s)\n", nbytes, size, errno, strerror(errno));
    }

    return 0;
}

qlog_ops_t asr_qlog_ops = {
    .init_filter = asr_init_filter,
    .logfile_init = asr_logfile_init,
};
