@echo off

echo=

set Start_at=%time%
set curtitle=cmd: %0 %*

echo ***************CMD for custom*****************

set MODE=UPLOAD
set DOWNLOAD_Mode=UART_MODE
set DOWNLOAD_Port=COM44
set FlashAddr=0
set FlashLen=1c000
set ReadName=update
set ReadFlashMode=1
set FlashConfigFile=config_ec618_uart.ini

if "%MODE%"=="DOWNLOAD" (
echo *************** UART DOWNLOAD MODE *********************

echo *************** Send Cmd for reset *********************
perl uart_send.pl 

echo ************** step1 connect *******************
FlashToolCLI.exe --cfgfile %FlashConfigFile% --port %DOWNLOAD_Port% probe

echo ************** step2 erase *******************
FlashToolCLI.exe --skipconnect 1 --cfgfile %FlashConfigFile% --port %DOWNLOAD_Port% flasherase %FlashAddr% %FlashLen%

echo ************** step3 burn *******************
FlashToolCLI.exe --skipconnect 1 --cfgfile %FlashConfigFile% --port %DOWNLOAD_Port% burnbatch --imglist bootloader flexfile3

echo ************** step4 reset *******************
FlashToolCLI.exe --skipconnect 1 --cfgfile %FlashConfigFile% --port %DOWNLOAD_Port% sysreset
) else if "%MODE%"=="UPLOAD" (

echo *************** UART UPLOAD MODE *********************

echo ************** step1 package extract and check *******************
FlashToolCLI.exe --cfgfile %FlashConfigFile% pkg2img

echo *************** Send Cmd for reset *********************
perl uart_send.pl 

echo ************** step2 connect *******************
FlashToolCLI.exe --cfgfile %FlashConfigFile% --port %DOWNLOAD_Port% probe

echo ************** step3 read data *******************
FlashToolCLI.exe --skipconnect 1 --cfgfile %FlashConfigFile% --port %DOWNLOAD_Port% flashread --memrbf %ReadName%.bin --flhstep64k %ReadFlashMode%  --stor_type ap_flash %FlashAddr% %FlashLen%

echo ************** step4 reset *******************
FlashToolCLI.exe --skipconnect 1 --cfgfile %FlashConfigFile% --port %DOWNLOAD_Port% sysreset

) 