#include <algorithm>
#include <iostream>
#include <string>
#include <vector>

//now let's think OOP:
class student
{
	//not very familiar with the string class,
	//but the task calls for arbitrary length
	std::string name;
	//not familiar with the vector too, but oh well
	std::vector<float> marks;
	//I first used int for the marks vector, but why not add
	//the option to store floating poing grades
	
	uint64_t faculty_num;

	public:
	/*
	void set_name(std::string name)
	{
		name = name;
	}
	*/

	//better to set the name in the contructor
	student(std::string name)
	{
		this->name = name;
		//give rand another seed to prevent the same num going out again
		srand ( time(NULL) );
	
		//this will not initialize the whole 64bit int
		//this->faculty_num = (uint64_t) rand();
		this->faculty_num = ((uint64_t)rand() << 32) | rand();
	}
	~student()
	{
		//std::cout << "The destructor\n";
	}

	void add_mark(float mark)
	{
		marks.push_back(mark);
	}

	//these string and vector get methods
	//are probably not very eficient because of copy on return
	//I think that the newer standards had options to return just 
	//a reference but I don't have experience with CPP
	std::vector<float> get_marks()
	{
		return this->marks;
	}

	std::string get_name()
	{
		return this->name;
	}

	uint64_t get_faculty_num()
	{
		return this->faculty_num;
	}
};

void student_gpa(std::vector<student> students, std::string name)
{
	for(int i=0; i<(int)students.size(); ++i)
	{
		if(students[i].get_name() == name)
		{
			//std::cout << "match " << name << "\n";
			float avg_grade = 0;
			std::vector<float> marks = students[i].get_marks();
			for(int i=0; i<(int)marks.size(); ++i)
			{
				avg_grade += marks[i];
			}
			std::cout << "Student " << students[i].get_faculty_num() << " '" << name << "' average grade is: ";
			printf("%.2f\n", avg_grade/marks.size()); 
			//we'll asume that there are no tho students with the same name
			return;
		}
	}
}

int main()
{
	std::vector<student> students;

	student student_obj("Tina");
	student_obj.add_mark(6);
	student_obj.add_mark(4);
	students.push_back(student_obj);

	student_obj = student("Rob");
	student_obj.add_mark(6);
	student_obj.add_mark(5);
	student_obj.add_mark(4.5);
	students.push_back(student_obj);
	
	student_obj = student("Carl");
	student_obj.add_mark(6);
	student_obj.add_mark(3);
	students.push_back(student_obj);

	student_gpa(students, "Rob");
	return 0;
}
