#include <iostream>
#include <cstring>
#include <climits>
#include <stdint.h>
#include <stdio.h>
#include <string.h>

//I'll not use namespace std


//the easyest way is to create a struct and then
//write an array of structs in the salary.bin file
//this is not a secure way to store annonymous data,
//as it can be easily reverse engineered. I'll not 
//have enough time to implement symmetric or asymmetric
//encryption though

#define MAX_POS_NAME_LEN	(64)
#define FILE_NAME		"salary.bin"
#define FILE_FULL_PATH		"./" FILE_NAME

#define FILE_MAX_NUM_ELEMENTS	(1000*1000)
struct salary_t
{
	char		position[MAX_POS_NAME_LEN];
	//16 bit would also be fine, (no dev with salary > 65k)
	//but the modern machines deal OK with 32 and 64 bit words 
	uint32_t	salary;
};

//here we use newer CPP standard to create a struct
//with variable length array at the end
//I think it was C++11 but don't quote me on that
struct salary_file_t
{
	uint32_t num_elements;
	salary_t salary_arr[];
};

long int get_file_size_and_seek_end(FILE *fptr)
{
	fseek(fptr, 0L, SEEK_END);
	return ftell(fptr);
}

FILE *get_file()
{
	FILE *fptr;

	fptr = fopen(FILE_FULL_PATH, "rb+");
	
	if(fptr == NULL)
	{
		std::cout << "There is no salary file creating one... \n";
		fptr = fopen(FILE_FULL_PATH, "wb+");
	}

	long int file_size = get_file_size_and_seek_end(fptr);
	std::cout <<"File size: "<< file_size << "\n";
	
	if(file_size < (long int)(sizeof(salary_t) + sizeof(uint32_t)) ||
			((file_size - sizeof(uint32_t)) % sizeof(salary_t)) != 0)
	{
		std::cout << "The salary file is corrupted. Creating new one and initializing... \n";
		fptr = fopen(FILE_FULL_PATH, "wb+");
		//here I'll not go into verbose error handling, sorry
		if(fptr == NULL) exit(-1);
		uint32_t num_elements = 0;
		fwrite(&num_elements, sizeof(num_elements), 1, fptr);
	}

	fseek(fptr, 0L, SEEK_SET);

	return fptr;
}

int main() {
	salary_file_t	*salary_file;

	FILE *fp = get_file();
	uint32_t num_elements;

	fread(&num_elements, sizeof(num_elements), 1, fp);
	std::cout << num_elements << "\n";

	//do not malloc absurd amount of memory
	if(num_elements > FILE_MAX_NUM_ELEMENTS) exit(-1);

	salary_file = (salary_file_t *)malloc(sizeof(salary_t)*num_elements + sizeof(uint32_t));
	if(salary_file == NULL) exit(-1);
	fseek(fp, 0L, SEEK_SET);
	//salary_file->num_elements = num_elements;
	fread(salary_file, 1, sizeof(salary_t)*num_elements + sizeof(uint32_t), fp);

	char input_str[MAX_POS_NAME_LEN+6];
	while(1)	
	{
		char input_line[MAX_POS_NAME_LEN+6];
		uint32_t input_num = 0;
		std::cout << "Please input position name and salary\n";

		//solve potential input overflow by using fgets();
		fgets(input_line, sizeof(input_line)-1, stdin);
		int args_parsed = sscanf(input_line, "%[^0123456789] %u", input_str, &input_num); 
		if(args_parsed < 1)
		{
			std::cout << "Invalid input line \n";
			//here we may exit instead
			continue;
		}

		if(args_parsed == 1)
		{
			std::cout << "End of input \n";
			//remove trailing '\n'
			sscanf(input_line, "%s", input_str); 
			break;
		}

		//expand the struct to accomodate the new entry
		//this is not very efficient because every realloc adds overhead(new syscall)
		//but for that purpose it's fine. In performance demandig app we will
		//realloc bigger memory at a time and then skip calls until the array is full again
		//here I should be fine using element of the array as parameter for realloc
		void *salary_file_temp = realloc(salary_file, sizeof(salary_t)*(salary_file->num_elements+1) + sizeof(uint32_t));
		//also note that in most systems min memory block for allocation is 4k, so this repeating invocation is doing nothing most of the time
		if(salary_file_temp == NULL) exit(-1);
		salary_file = (salary_file_t *)salary_file_temp;

		salary_file->salary_arr[salary_file->num_elements].salary = input_num;

		//this is unsafe(ask me how I know...) because it may truncate the '\0' char at the end
		//strncpy(salary_file->salary_arr[num_elements].position, input_str, MAX_POS_NAME_LEN);

		//use this instead
		snprintf(salary_file->salary_arr[salary_file->num_elements].position, MAX_POS_NAME_LEN, "%.*s", MAX_POS_NAME_LEN-1, input_str);
		salary_file->num_elements += 1;
	}

	fseek(fp, 0L, SEEK_SET);
	fwrite(salary_file, (sizeof(salary_t)*salary_file->num_elements + sizeof(uint32_t)), 1, fp);
	fclose(fp);

	float median_salary = 0;
	int matching_entries = 0;

	for(uint32_t i=0; i<salary_file->num_elements; ++i)
	{
		char *ptr = strstr(salary_file->salary_arr[i].position, input_str);
		if(ptr != NULL)
		{
			median_salary += salary_file->salary_arr[i].salary;
			matching_entries++;
			//std::cout << "med salary " << salary_file->salary_arr[i].salary << "\n";
		}
	}
	
	if(matching_entries == 0)
	{
		//std::cout<< "No matching entries\n";
	}
	else printf("Median salary of '%s' is: %.2f \n", input_str, (float)(median_salary / matching_entries));
	std::cout << "End of my humble program\n";
	//probably I instead of exit() I should use my own function to free the struct
	//before I quit, but will leave that to the kernel for naw
	free(salary_file);
	//std::system("pause");
	return 0;
}

