#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>

/* The fastest way to determine if
 * an integer is a power of 2 should be
 * to break it down to it's binary representation
 * if only 1 of it's N number of bits is set to 1
 * and all others are set to 0, the num is pow of 2
 * if we substract 1, from the number all the below bits
 * will end up set to 1 and the others to 0
 * also handle the edge case where the num is 0
 */

bool
is_pow_of_two_u32 (uint32_t number)
{
  return number && (!(number & (number - 1)));
}

int
main (int argc, char *argv[])
{
  if (argc != 2) {
    printf ("Please input a number\n");
    return -1;
  }

  printf ("The number %s a power of two\n",
	  is_pow_of_two_u32 (strtol (argv[1], NULL, 10)) == true ? "is" : "isn't");

  return 0;
}
